%define name iser
%define version 2.6
%define release 18

Summary		: iSER kernel module.
Name		: %{name}
Version		: %{version}
Release		: %{release}
Vendor		: Voltaire Inc.
Source		: iser-%{version}.tar.gz
Packager	: Erez Zilber <erezz@voltaire.com>
Provides	: iSER
Group		: Storage 
License		: GPL
BuildRoot:      %{_tmppath}/%{name}


%description
This package provides iSER kernel module

%define kversion $(uname -r)
%define kernel_src /lib/modules/`uname -r`/source

%prep
echo "Checking if the kernel source is installed"

%if "%{_vendor}" == "suse"
	if ! ( $(rpm -q kernel-source > /dev/null 2>&1) ) ; then
		echo "Cannot build. Please install the kernel-source rpm first"
		exit 1
	fi
%else
%if "%{_vendor}" == "redhat"
	if ! ( $(rpm -q kernel-devel > /dev/null 2>&1) ) ; then
		echo "Cannot build. Please install the kernel-devel rpm first"
		exit 1
	fi
%endif
%endif

rm -rf $RPM_BUILD_ROOT

%setup

# apply relevant patches for distro
case $(uname -r | sed "s/-ppc64\|-smp//") in
        2.6.16.21-0.8)
		for found_patch in $(find $PWD/patches/sles10 -name *.patch | sort) ; do
			if ! [ -z "$found_patch" ] ; then
				patch -p1 < $found_patch
			fi
		done
                ;; 
        *)
                echo "%{kversion} kernel is not supported"
                exit 1
                ;;
esac

%build

echo "Building iSER kernel module"
if make -C /lib/modules/`uname -r`/build SUBDIRS="$PWD/drivers/infiniband/ulp/iser" \
		V=1  \
		LINUXINCLUDE="-I$PWD/include -I/lib/modules/$(uname -r)/source/include -Iinclude -Iinclude2" \
		CONFIG_INFINIBAND_ISER=m; then
        echo "iSER driver built OK"
	bail_out=0
else
        echo "Failed to build iSER driver, cleaning up..."
	bail_out=1
fi

if [ $bail_out = 1 ] ; then
        echo "Unable to build the iSER driver"
        exit 1
fi

%install
# delete the dir where the modules were built
if [ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] ; then rm -rf ${RPM_BUILD_ROOT} ; fi

%define MODULE_LIST ib_iser.ko

# install the open-iscsi modules into our tmp dir
2>&1 make -C /lib/modules/%{kversion}/build/ SUBDIRS=$PWD/drivers/infiniband/ulp/iser modules_install INSTALL_MOD_PATH=${RPM_BUILD_ROOT}/tmp |grep INSTALL

# put the new iSER module in a tmp location
found_file=$(find ${RPM_BUILD_ROOT}/tmp | grep ib_iser.ko)
if ! [ -z "$found_file" ] ; then
	found_file_dir=$(dirname $found_file)
	found_file_dir=$(echo $found_file_dir|sed "s|${RPM_BUILD_ROOT}/tmp||")
	mkdir -p ${RPM_BUILD_ROOT}$found_file_dir
	install -m755 $found_file ${RPM_BUILD_ROOT}$found_file_dir
fi

rm -rf ${RPM_BUILD_ROOT}/tmp

# build the file list
FILE_LIST=%{_tmppath}/iser-file-list

find ${RPM_BUILD_ROOT} -type f| sed "s|${RPM_BUILD_ROOT}||" > ${FILE_LIST}
cat ${FILE_LIST}

%clean
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

%pre

# set backup dir
if [ ! -z $STACK_PREFIX ] ; then
	backup_dir=$STACK_PREFIX/backup
else
	backup_dir=/usr/local/gs/backup
fi
KERNEL=$(uname -r)
echo "Backup /lib/modules/$KERNEL"

# backup kernel module
found_file=$(find /lib/modules/$KERNEL | grep ib_iser.ko)
if ! [ -z "$found_file" ] ; then
	found_file_dir=$(dirname $found_file)
	mkdir -p $backup_dir/$found_file_dir
	mv $found_file $backup_dir/$found_file_dir
fi

%post
depmod -a

exit 0

%postun
STACK_PREFIX=$(test -x /etc/infiniband/info && /etc/infiniband/info |grep prefix|cut -f2 -d=)
if [ ! -z $STACK_PREFIX ] ; then
	backup_dir=$STACK_PREFIX/backup
else
	backup_dir=/usr/local/gs/backup
fi
echo "Restoring /lib/modules/$(uname -r)"
cd $backup_dir
found_file=$(find -name ib_iser.ko)
if ! [ -z "$found_file" ] ; then
	found_file_dir=$(dirname $found_file|cut -f2- -d/)
	cp $found_file /$found_file_dir
fi

%files -f %{_tmppath}/iser-file-list

